{{-- resources/views/admin/approval-cuti.blade.php --}}
@extends(is_admin_mode()
    ? 'admin.layouts.app'
    : 'karyawan.layout.master')
{{-- resources/views/admin/approval-cuti.blade.php --}}


@section('title', 'Approval Cuti')
{{-- resources/views/admin/approval-cuti-styles.blade.php --}}
@push('styles')


<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
    }

    body {
        margin: 0;
        padding: 0;
        background: #ffffff;
        overflow: hidden;
    }

    /* ===== WRAPPER - FULLSCREEN LIKE NOTIFIKASI ===== */
    .approval-wrapper {
        margin-top: 70px; /* Account for header */
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        display: flex;
        flex-direction: column;
        background: #ffffff;
    }

    /* ===== FILTER TABS (sama seperti notifikasi) ===== */
    .filter-tabs {
        display: flex;
        gap: 0;
        background: #f8f9fa;
        padding: 0;
        border-bottom: 2px solid #e9ecef;
        flex-shrink: 0;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    .tab-btn {
        flex: 0 0 auto;
        min-width: max-content;
        padding: 14px 20px;
        background: transparent;
        border: none;
        color: #6c757d;
        font-size: 15px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.2s;
        position: relative;
        white-space: nowrap;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .tab-btn i {
        font-size: 14px;
    }

    .tab-btn.active {
        color: #212529;
        font-weight: 600;
    }

    .tab-btn.active::after {
        content: '';
        position: absolute;
        bottom: -2px;
        left: 0;
        right: 0;
        height: 2px;
        background: #212529;
    }

    /* ===== STATS BANNER ===== */
    .stats-banner {
        display: flex;
        gap: 0;
        background: white;
        border-bottom: 1px solid #e9ecef;
        flex-shrink: 0;
        padding: 12px 0;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }

    .stat-item {
        flex: 0 0 auto;
        min-width: max-content;
        padding: 12px 20px;
        text-align: center;
        border-right: 1px solid #e9ecef;
    }

    .stat-item:last-child {
        border-right: none;
    }

    .stat-value {
        font-size: 24px;
        font-weight: 700;
        color: #212529;
        line-height: 1;
        margin-bottom: 4px;
    }

    .stat-label {
        font-size: 11px;
        color: #6c757d;
        font-weight: 600;
        text-transform: uppercase;
    }

    /* ===== APPROVAL LIST ===== */
    .approval-list {
        flex: 1;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
        padding: 0;
        background: #ffffff;
        margin-bottom: 60px; /* Account for bottom nav */
    }

    .approval-item {
        border-bottom: 1px solid #f0f0f0;
        display: flex;
        flex-direction: column;
    }

    /* ===== APPROVAL CARD ===== */
    .approval-card {
        padding: 16px 20px;
        display: flex;
        gap: 16px;
        align-items: flex-start;
        background: white;
        transition: background 0.2s;
        cursor: pointer;
        text-decoration: none;
        color: inherit;
    }

    .approval-card:active {
        background: #fafafa;
    }

    .approval-card.your-turn {
        background: #fffbf0;
        border-left: 4px solid #ffc107;
    }

    /* Avatar Icon */
    .approval-icon {
        flex-shrink: 0;
    }

    .avatar-circle {
        width: 48px;
        height: 48px;
        border-radius: 50%;
        background: linear-gradient(135deg, #4285f4 0%, #5a98f7 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 20px;
        font-weight: 700;
    }

    /* Content */
    .approval-content {
        flex: 1;
        min-width: 0;
    }

    .approval-header {
        display: flex;
        justify-content: space-between;
        gap: 12px;
        margin-bottom: 8px;
        align-items: flex-start;
    }

    .approval-title {
        font-size: 16px;
        font-weight: 600;
        color: #212529;
        margin: 0 0 2px 0;
        word-break: break-word;
    }

    .approval-subtitle {
        font-size: 13px;
        color: #6c757d;
        margin: 0;
    }

    .cuti-badge {
        background: linear-gradient(135deg, #FF6B35 0%, #F7931E 100%);
        color: white;
        padding: 4px 10px;
        border-radius: 12px;
        font-size: 11px;
        font-weight: 700;
        white-space: nowrap;
        flex-shrink: 0;
    }

    /* Dates */
    .approval-dates {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 8px;
        font-size: 13px;
        color: #495057;
    }

    .approval-dates i {
        color: #4285f4;
        font-size: 14px;
        flex-shrink: 0;
    }

    .date-text {
        display: flex;
        flex-direction: column;
        gap: 2px;
    }

    .date-text small {
        font-size: 11px;
        color: #6c757d;
    }

    /* Reason */
    .approval-reason {
        margin-bottom: 10px;
    }

    .reason-label {
        font-size: 10px;
        color: #6c757d;
        font-weight: 700;
        text-transform: uppercase;
        display: block;
        margin-bottom: 3px;
    }

    .reason-text {
        font-size: 13px;
        color: #495057;
        margin: 0;
        line-height: 1.4;
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }

    /* Progress */
    .approval-progress {
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 11px;
        color: #6c757d;
    }

    .progress-bar {
        flex: 1;
        height: 3px;
        background: #e9ecef;
        border-radius: 2px;
        overflow: hidden;
    }

    .progress-fill {
        height: 100%;
        background: linear-gradient(90deg, #4285f4, #5a98f7);
        transition: width 0.3s ease;
    }

    .progress-text {
        font-size: 11px;
        color: #6c757d;
        white-space: nowrap;
    }

    /* Status Badge */
    .approval-status {
        flex-shrink: 0;
        margin-left: 8px;
    }

    .badge-turn {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        background: #fff3cd;
        color: #856404;
        padding: 6px 10px;
        border-radius: 12px;
        font-size: 11px;
        font-weight: 700;
    }

    .badge-turn i {
        font-size: 10px;
        animation: pulse 1.5s infinite;
    }

    .badge-waiting {
        display: inline-flex;
        align-items: center;
        gap: 4px;
        background: #e2e8f0;
        color: #4a5568;
        padding: 4px 8px;
        border-radius: 6px;
        font-size: 10px;
        font-weight: 700;
    }

    .badge-waiting i {
        font-size: 9px;
    }

    @keyframes pulse {
        0%, 100% { opacity: 1; }
        50% { opacity: 0.5; }
    }

    /* ===== ACTION BUTTONS ===== */
    .approval-actions {
        display: none; /* Hidden on mobile */
        padding: 12px 20px;
        border-top: 1px solid #f0f0f0;
        display: flex;
        gap: 8px;
        background: #fafafa;
    }

    .btn-action {
        flex: 1;
        padding: 8px 12px;
        border: none;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
    }

    .btn-approve {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
    }

    .btn-approve:hover {
        box-shadow: 0 4px 12px rgba(40, 167, 69, 0.3);
    }

    .btn-reject {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        color: white;
    }

    .btn-reject:hover {
        box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
    }

    /* ===== EMPTY STATE ===== */
    .empty-state {
        text-align: center;
        padding: 80px 20px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    .empty-icon {
        width: 80px;
        height: 80px;
        margin: 0 auto 20px;
        background: #f8f9fa;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #adb5bd;
        font-size: 36px;
    }

    .empty-state h3 {
        font-size: 16px;
        color: #495057;
        margin-bottom: 6px;
        font-weight: 600;
    }

    .empty-state p {
        font-size: 13px;
        color: #adb5bd;
    }

    /* ===== PAGINATION ===== */
    .pagination-wrapper {
        padding: 16px 20px;
        background: white;
        border-top: 1px solid #e9ecef;
        flex-shrink: 0;
    }

    .pagination {
        display: flex;
        justify-content: center;
        gap: 6px;
        margin: 0;
        padding: 0;
        list-style: none;
        flex-wrap: wrap;
    }

    .pagination a,
    .pagination span {
        width: 36px;
        height: 36px;
        border-radius: 6px;
        font-size: 13px;
        color: #495057;
        text-decoration: none;
        background: #f8f9fa;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 500;
        transition: all 0.2s;
    }

    .pagination a:hover {
        background: #2d2d2e;
        color: white;
    }

    .pagination .active span {
        background: #2d2d2e;
        color: white;
    }

    /* ===== MODAL ===== */
    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 2000;
        align-items: flex-end;
        justify-content: center;
        padding: 20px;
    }

    .modal.show {
        display: flex;
    }

    .modal-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: -1;
    }

    .modal-content {
        background: white;
        padding: 25px;
        border-radius: 16px 16px 0 0;
        width: 100%;
        max-width: 500px;
        max-height: 90vh;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
        animation: slideUp 0.3s ease-out;
    }

    @keyframes slideUp {
        from {
            transform: translateY(100%);
        }
        to {
            transform: translateY(0);
        }
    }

    .modal-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 20px;
        padding-bottom: 15px;
        border-bottom: 1px solid #e9ecef;
    }

    .modal-header h3 {
        font-size: 18px;
        font-weight: 700;
        color: #212529;
        margin: 0;
    }

    .modal-close {
        background: none;
        border: none;
        color: #6c757d;
        font-size: 20px;
        cursor: pointer;
        padding: 0;
        width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: color 0.2s;
    }

    .modal-close:hover {
        color: #212529;
    }

    .modal-body {
        display: flex;
        flex-direction: column;
        gap: 16px;
    }

    .form-group {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .form-group label {
        font-size: 14px;
        font-weight: 600;
        color: #212529;
    }

    .form-group .required {
        color: #dc3545;
    }

    .form-group textarea {
        padding: 12px;
        border: 2px solid #e9ecef;
        border-radius: 8px;
        font-size: 14px;
        font-family: inherit;
        resize: vertical;
        transition: border-color 0.2s;
    }

    .form-group textarea:focus {
        outline: none;
        border-color: #4285f4;
    }

    .form-group small {
        font-size: 12px;
        color: #6c757d;
    }

    .modal-footer {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 12px;
        margin-top: 20px;
        padding-top: 20px;
        border-top: 1px solid #e9ecef;
    }

    .btn-modal {
        padding: 12px 16px;
        border: none;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
    }

    .btn-cancel {
        background: #e9ecef;
        color: #212529;
    }

    .btn-cancel:hover {
        background: #dee2e6;
    }

    .btn-submit {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        color: white;
    }

    .btn-submit:hover {
        box-shadow: 0 4px 12px rgba(220, 53, 69, 0.3);
    }

    /* ===== TABLET & DESKTOP RESPONSIVENESS ===== */
    @media (min-width: 769px) {
        .approval-wrapper {
            margin-top: 70px;
            position: relative;
            flex-direction: column;
        }

        .filter-tabs {
            position: sticky;
            top: 70px;
            z-index: 100;
        }

        .stats-banner {
            position: sticky;
            top: calc(70px + 53px); /* header + tabs */
            z-index: 99;
            background: white;
            border-bottom: 2px solid #e9ecef;
        }

        .approval-list {
            margin-bottom: 0;
            padding: 20px;
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(500px, 1fr));
            gap: 20px;
        }

        .approval-item {
            border-bottom: none;
            flex-direction: row;
            border: 1px solid #e9ecef;
            border-radius: 12px;
            overflow: hidden;
        }

        .approval-card {
            padding: 20px;
            flex-direction: column;
            border-left: 4px solid #4285f4;
            border-radius: 8px 0 0 8px;
            transition: all 0.2s;
        }

        .approval-card:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }

        .approval-card.your-turn {
            border-left-color: #ffc107;
            background: #fffbf0;
        }

        .approval-actions {
            display: flex !important;
            flex-direction: column;
            padding: 0;
            border: none;
            border-left: 1px solid #e9ecef;
            border-radius: 0;
            gap: 0;
            background: #fafafa;
            min-width: 120px;
        }

        .btn-action {
            flex: 1;
            border-radius: 0;
            border-bottom: 1px solid #e9ecef;
            margin: 0;
            padding: 12px 16px;
        }

        .btn-action:last-child {
            border-bottom: none;
        }

        .empty-state {
            padding: 120px 20px;
        }

        .modal-content {
            border-radius: 12px;
            max-width: 500px;
        }
    }

    /* ===== TABLET RESPONSIVE ===== */
    @media (max-width: 768px) and (min-width: 481px) {
        .filter-tabs {
            padding: 0 12px;
        }

        .tab-btn {
            padding: 12px 16px;
        }

        .stats-banner {
            padding: 14px 12px;
        }

        .approval-card {
            padding: 14px 16px;
            gap: 14px;
        }

        .avatar-circle {
            width: 44px;
            height: 44px;
            font-size: 18px;
        }

        .approval-title {
            font-size: 15px;
        }

        .empty-state {
            padding: 60px 16px;
        }
    }

    /* ===== MOBILE RESPONSIVE (< 480px) ===== */
    @media (max-width: 480px) {
        .filter-tabs {
            padding: 0 12px;
        }

        .tab-btn {
            padding: 10px 14px;
            font-size: 13px;
            gap: 6px;
        }

        .tab-btn i {
            font-size: 13px;
        }

        .stats-banner {
            padding: 10px 0;
        }

        .stat-item {
            padding: 10px 16px;
            flex: 1;
            border-right: 1px solid #e9ecef;
        }

        .stat-item:last-child {
            border-right: none;
        }

        .stat-value {
            font-size: 20px;
        }

        .stat-label {
            font-size: 10px;
        }

        .approval-card {
            padding: 12px 16px;
            gap: 12px;
        }

        .avatar-circle {
            width: 40px;
            height: 40px;
            font-size: 16px;
            flex-shrink: 0;
        }

        .approval-title {
            font-size: 14px;
        }

        .approval-subtitle {
            font-size: 12px;
        }

        .cuti-badge {
            padding: 3px 8px;
            font-size: 10px;
        }

        .approval-dates {
            font-size: 12px;
        }

        .approval-dates i {
            font-size: 13px;
        }

        .reason-text {
            font-size: 12px;
        }

        .badge-turn {
            padding: 4px 8px;
            font-size: 10px;
            gap: 4px;
        }

        .badge-turn i {
            font-size: 9px;
        }

        .empty-state {
            padding: 50px 12px;
        }

        .empty-icon {
            width: 64px;
            height: 64px;
            font-size: 28px;
        }

        .empty-state h3 {
            font-size: 14px;
        }

        .empty-state p {
            font-size: 12px;
        }

        .modal-content {
            border-radius: 20px 20px 0 0;
            padding: 20px;
        }

        .modal-header h3 {
            font-size: 16px;
        }

        .form-group label {
            font-size: 13px;
        }

        .form-group textarea {
            font-size: 14px;
            padding: 10px;
        }

        .btn-modal {
            padding: 10px 14px;
            font-size: 13px;
        }
    }

    /* ===== EXTRA SMALL MOBILE (< 360px) ===== */
    @media (max-width: 360px) {
        .tab-btn {
            padding: 8px 12px;
            font-size: 12px;
        }

        .stat-item {
            padding: 8px 12px;
        }

        .stat-value {
            font-size: 18px;
        }

        .approval-card {
            padding: 10px 12px;
            gap: 10px;
        }

        .approval-title {
            font-size: 13px;
        }

        .approval-subtitle {
            font-size: 11px;
        }

        .reason-text {
            font-size: 11px;
        }
    }
</style>
@endpush
@section('content')
<div class="approval-wrapper">
    <!-- Filter Tabs (sama seperti notifikasi) -->
    <div class="filter-tabs">
        <button class="tab-btn active" data-filter="all">
            <i class="fas fa-list"></i> Semua
        </button>
        <button class="tab-btn" data-filter="pending">
            <i class="fas fa-clock"></i> Menunggu
        </button>
    </div>

    <!-- Stats Banner -->
    <div class="stats-banner">
        <div class="stat-item">
            <div class="stat-value">{{ $cutiCount['pending'] ?? 0 }}</div>
            <div class="stat-label">Menunggu</div>
        </div>
        <div class="stat-item">
            <div class="stat-value">{{ $approvedToday ?? 0 }}</div>
            <div class="stat-label">Hari Ini</div>
        </div>
        <div class="stat-item">
            <div class="stat-value">{{ $rejectedToday ?? 0 }}</div>
            <div class="stat-label">Ditolak</div>
        </div>
    </div>

    <!-- Approval List -->
    <div class="approval-list">
        @forelse($cuti as $item)
            @php
                $isYourTurn = $item->current_step === Auth::user()->role;

                $totalApprovals = $item->approvals->count();
                $completedApprovals = $item->approvals->where('status', '!=', 'pending')->count();
                $progressPercent = $totalApprovals > 0 ? ($completedApprovals / $totalApprovals) * 100 : 0;
            @endphp

            <div class="approval-item" data-type="pending">
                <a href="{{ route('admin.approval-cuti.detail', $item->id) }}" class="approval-card {{ $isYourTurn ? 'your-turn' : '' }}">
                    <!-- Left Section: Employee Avatar -->
                    <div class="approval-icon">
                        <div class="avatar-circle">
                            {{ strtoupper(substr($item->karyawan->user->nama, 0, 1)) }}
                        </div>
                    </div>

                    <!-- Middle Section: Info -->
                    <div class="approval-content">
                        <div class="approval-header">
                            <div>
                                <h3 class="approval-title">{{ $item->karyawan->user->nama }}</h3>
                                <p class="approval-subtitle">{{ $item->karyawan->departemen->nama }}</p>
                            </div>
                            <span class="cuti-badge">{{ $item->jenisCuti->nama }}</span>
                        </div>

                        <div class="approval-dates">
                            <i class="fas fa-calendar-alt"></i>
                            <span class="date-text">
                                {{ $item->tanggal_mulai->format('d M') }} - {{ $item->tanggal_selesai->format('d M Y') }}
                                <small>{{ $item->jumlahHari }} hari</small>
                            </span>
                        </div>

                        <div class="approval-reason">
                            <span class="reason-label">Alasan:</span>
                            <p class="reason-text">{{ $item->alasan }}</p>
                        </div>

                        <div class="approval-progress">
                            <div class="progress-bar">
                                <div class="progress-fill" style="width: {{ $progressPercent }}%"></div>
                            </div>
                            <span class="progress-text">{{ round($progressPercent) }}% selesai</span>
                        </div>
                    </div>

                    <!-- Right Section: Status Badge -->
                    <div class="approval-status">
                        @if($isYourTurn)
                        <span class="badge-turn">
                            <i class="fas fa-bell"></i>
                            <span>Giliran</span>
                        </span>
                        @else
                        <span class="badge-waiting">
                            <i class="fas fa-hourglass-half"></i>
                            <span>{{ strtoupper(substr($item->current_step, 0, 3)) }}</span>
                        </span>
                        @endif
                    </div>
                </a>

                <!-- Action Buttons (Appear on desktop, inline on mobile) -->
                @if($isYourTurn)
                <div class="approval-actions">
                    <button class="btn-action btn-approve" onclick="event.preventDefault(); quickApprove({{ $item->id }})" title="Setujui">
                        <i class="fas fa-check"></i>
                        <span>Setujui</span>
                    </button>
                    <button class="btn-action btn-reject" onclick="event.preventDefault(); showRejectModal({{ $item->id }})" title="Tolak">
                        <i class="fas fa-times"></i>
                        <span>Tolak</span>
                    </button>
                </div>
                @endif
            </div>
        @empty
            <div class="empty-state">
                <div class="empty-icon">
                    <i class="fas fa-inbox"></i>
                </div>
                <h3>Tidak ada cuti yang menunggu</h3>
                <p>Semua approval cuti sudah selesai</p>
            </div>
        @endforelse
    </div>

    <!-- Pagination -->
    @if($cuti->hasPages())
    <div class="pagination-wrapper">
        {{ $cuti->links() }}
    </div>
    @endif
</div>

<!-- Reject Modal -->
<div id="rejectModal" class="modal">
    <div class="modal-overlay"></div>
    <div class="modal-content">
        <div class="modal-header">
            <h3>Tolak Pengajuan Cuti</h3>
            <button class="modal-close" onclick="closeRejectModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <form id="rejectForm" method="POST" class="modal-body">
            @csrf

            <div class="form-group">
                <label>Alasan Penolakan <span class="required">*</span></label>
                <textarea
                    name="catatan_admin"
                    placeholder="Jelaskan alasan penolakan..."
                    required
                    minlength="10"
                    rows="4"
                ></textarea>
                <small>Minimum 10 karakter</small>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn-modal btn-cancel" onclick="closeRejectModal()">
                    Batal
                </button>
                <button type="submit" class="btn-modal btn-submit">
                    <i class="fas fa-times"></i> Tolak
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

{{-- resources/views/admin/approval-cuti-scripts.blade.php --}}
@push('scripts')

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const tabBtns = document.querySelectorAll('.tab-btn');
        const approvalItems = document.querySelectorAll('.approval-item');

        // Tab filtering functionality
        tabBtns.forEach(btn => {
            btn.addEventListener('click', function() {
                // Update active tab
                tabBtns.forEach(b => b.classList.remove('active'));
                this.classList.add('active');

                // Scroll active tab into view (untuk mobile)
                const tabsContainer = document.querySelector('.filter-tabs');
                const activeBtn = this;

                if (tabsContainer && activeBtn) {
                    setTimeout(() => {
                        const btnRect = activeBtn.getBoundingClientRect();
                        const containerRect = tabsContainer.getBoundingClientRect();

                        if (btnRect.left < containerRect.left) {
                            activeBtn.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'start' });
                        } else if (btnRect.right > containerRect.right) {
                            activeBtn.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'end' });
                        }
                    }, 100);
                }

                // Filter approvals
                const filter = this.dataset.filter;
                let visibleCount = 0;

                approvalItems.forEach(item => {
                    if (filter === 'all') {
                        item.style.display = 'flex';
                        visibleCount++;
                    } else {
                        if (item.dataset.type === filter) {
                            item.style.display = 'flex';
                            visibleCount++;
                        } else {
                            item.style.display = 'none';
                        }
                    }
                });

                // Show empty state jika tidak ada approval
                const listContainer = document.querySelector('.approval-list');
                const emptyState = listContainer.querySelector('.empty-state');

                if (visibleCount === 0 && !emptyState) {
                    const noDataDiv = document.createElement('div');
                    noDataDiv.className = 'empty-state';
                    noDataDiv.innerHTML = `
                        <div class="empty-icon">
                            <i class="fas fa-inbox"></i>
                        </div>
                        <h3>Tidak ada pengajuan cuti</h3>
                        <p>Tidak ada pengajuan cuti untuk kategori ini</p>
                    `;
                    listContainer.appendChild(noDataDiv);
                } else if (visibleCount > 0 && emptyState) {
                    emptyState.remove();
                }
            });
        });

        // Auto-scroll to first tab on load
        const firstTab = document.querySelector('.tab-btn.active');
        if (firstTab && document.querySelector('.filter-tabs')) {
            setTimeout(() => {
                firstTab.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'start' });
            }, 300);
        }
    });

    // ===== APPROVAL FUNCTIONS =====

    function quickApprove(id) {
        if (confirm('Setujui pengajuan cuti ini?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `{{ route('admin.cuti.approve', ':id') }}`.replace(':id', id);
            form.innerHTML = `
                @csrf
                <input type="hidden" name="catatan_admin" value="">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    }

    function showRejectModal(id) {
        window.rejectCutiId = id;
        document.getElementById('rejectModal').classList.add('show');
        document.body.style.overflow = 'hidden';

        const form = document.getElementById('rejectForm');
        form.action = `{{ route('admin.cuti.reject', ':id') }}`.replace(':id', id);
        form.querySelector('textarea').focus();
    }

    function closeRejectModal() {
        document.getElementById('rejectModal').classList.remove('show');
        document.body.style.overflow = '';
        document.getElementById('rejectForm').reset();
    }

    // Close modal when clicking overlay
    document.addEventListener('DOMContentLoaded', function() {
        const modal = document.getElementById('rejectModal');
        const overlay = modal.querySelector('.modal-overlay');

        if (overlay) {
            overlay.addEventListener('click', closeRejectModal);
        }

        // Close modal dengan ESC
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeRejectModal();
            }
        });
    });

    // Touch feedback untuk cards (sama seperti notifikasi)
    document.addEventListener('DOMContentLoaded', function() {
        const approvalCards = document.querySelectorAll('.approval-card');
        approvalCards.forEach(card => {
            card.addEventListener('touchstart', function(e) {
                if (e.target.closest('.btn-action')) {
                    e.preventDefault();
                }
            });
        });
    });

    // Handle viewport changes
    let viewportWidth = window.innerWidth;
    window.addEventListener('orientationchange', function() {
        const newWidth = window.innerWidth;
        if (newWidth !== viewportWidth) {
            viewportWidth = newWidth;
            const tabsContainer = document.querySelector('.filter-tabs');
            if (tabsContainer) {
                const activeBtn = document.querySelector('.tab-btn.active');
                if (activeBtn) {
                    activeBtn.scrollIntoView({ behavior: 'smooth', block: 'nearest', inline: 'center' });
                }
            }
        }
    });

    // Toast notification (jika ada session)
    document.addEventListener('DOMContentLoaded', function() {
        @if(session('success'))
            showNotification('{{ session('success') }}', 'success');
        @endif
        @if(session('error'))
            showNotification('{{ session('error') }}', 'error');
        @endif
    });

    function showNotification(message, type = 'success') {
        const toast = document.createElement('div');
        toast.style.cssText = `
            position: fixed;
            bottom: 100px;
            left: 50%;
            transform: translateX(-50%);
            padding: 14px 20px;
            background: ${type === 'success' ? '#28a745' : '#dc3545'};
            color: white;
            border-radius: 8px;
            font-weight: 600;
            font-size: 14px;
            z-index: 3000;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            animation: slideInUp 0.3s ease-out;
        `;
        toast.textContent = message;
        document.body.appendChild(toast);

        setTimeout(() => {
            toast.style.animation = 'slideInUp 0.3s ease-out reverse';
            setTimeout(() => toast.remove(), 300);
        }, 4000);
    }

    // Prevent scroll when modal is open
    function lockScroll() {
        document.body.style.overflow = 'hidden';
    }

    function unlockScroll() {
        document.body.style.overflow = '';
    }
</script>
@endpush
{{--
@include('admin.approval-cuti-styles')
@include('admin.approval-cuti-scripts') --}}
